import * from dw::Runtime

var jsonDF = findDataFormatDescriptorByMime({'type': "*", subtype: "json", parameters: {}})
var multipartDF = findDataFormatDescriptorByMime({'type': "multipart", subtype: "form-data", parameters: {}})
var unknownDF = findDataFormatDescriptorByMime({'type': "*", subtype: "*", parameters: {}})

fun simplify(df: DataFormatDescriptor | Null) = df  match {
	case d is DataFormatDescriptor -> { name: d.name, defaultMimeType: d.defaultMimeType }
	case is Null -> { name: "unknown", defaultMimeType: "unknown" }
}
---
{
  "json": simplify(jsonDF),
  "multipart": simplify(multipartDF),
  "unknown": simplify(unknownDF),
}
