package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.DebuggerValue
import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint
import org.mule.weave.v2.debugger.commands.WeaveDebuggerCommandInterpreter

class DefaultWeaveDebuggerCommandInterpreter(debuggingSession: WeaveDebuggingSession) extends WeaveDebuggerCommandInterpreter {
  override def stepInto(): Unit = {
    debuggingSession.getWeaveDebuggerExecutor().stepInto()
  }

  override def resume(): Unit = {
    debuggingSession.getWeaveDebuggerExecutor().resume()
  }

  override def removeBreakpoint(breakpoint: WeaveBreakpoint): Unit = {
    debuggingSession.getWeaveBreakpointManager().removeBreakpoint(breakpoint)
  }

  override def nextStep(): Unit = {
    debuggingSession.getWeaveDebuggerExecutor().nextStep()
  }

  override def initSession(): Unit = {
    debuggingSession.initSession()
  }

  override def evaluateScript(script: String, frameId: Int): DebuggerValue = {
    debuggingSession.getWeaveDebuggerExecutor().evalScript(script, frameId)
  }

  override def clearBreakpoints(): Unit = {
    debuggingSession.getWeaveBreakpointManager().clearBreakpoints()
  }

  override def addBreakpoint(breakpoint: WeaveBreakpoint): Unit = {
    debuggingSession.getWeaveBreakpointManager().addBreakpoint(breakpoint)
  }

  override def addBreakpoints(breakpoint: Array[WeaveBreakpoint]): Unit = {
    breakpoint.foreach((b) => {
      debuggingSession.getWeaveBreakpointManager().addBreakpoint(b)
    })
  }

  override def stepOut(): Unit = {
    debuggingSession.getWeaveDebuggerExecutor().stepOut()
  }

  override def addExceptionBreakpoint(breakpoints: Array[WeaveExceptionBreakpoint]): Unit = {

    breakpoints.foreach((eb) => {
      debuggingSession.getWeaveBreakpointManager().addExceptionBreakpoint(eb)
    })
  }

  override def removeExceptionBreakpoint(breakpoint: WeaveExceptionBreakpoint): Unit = {
    debuggingSession.getWeaveBreakpointManager().removeExceptionBreakpoint(breakpoint)
  }
}
