package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.executors.BinaryOpExecutor
import org.mule.weave.v2.interpreted.node.executors.FunctionExecutor
import org.mule.weave.v2.model.values.Value

class BinaryOpNode(
  val binaryOpExecutor: BinaryOpExecutor,
  val lhs: ValueNode[_],
  val rhs: ValueNode[_]) extends ValueNode[Any] with Product3[FunctionExecutor, ValueNode[_], ValueNode[_]] {

  override def doExecute(implicit ctx: ExecutionContext): Value[_] = {
    binaryOpExecutor.executeBinary(lhs.execute, rhs.execute)
  }

  def operationName: String = binaryOpExecutor.name

  override def _1: FunctionExecutor = binaryOpExecutor

  override def _2: ValueNode[_] = lhs

  override def _3: ValueNode[_] = rhs

}

