package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.Value

class UnlessNode(ifExpr: ValueNode[_], condition: ValueNode[_], elseExpr: ValueNode[_]) extends ValueNode[Any] with Product2[ValueNode[_], ValueNode[_]] {
  override def doExecute(implicit executionContext: ExecutionContext): Value[_] = {
    if (!BooleanType.coerce(condition.execute, condition).evaluate) {
      ifExpr.execute
    } else {
      elseExpr.execute
    }
  }

  override def _1: ValueNode[_] = ifExpr

  override def _2: ValueNode[_] = elseExpr
}

object UnlessNode {
  def apply(ifExpr: ValueNode[_], condition: ValueNode[_], elseExpr: ValueNode[_]): ValueNode[_] = new UnlessNode(ifExpr, condition, elseExpr)
}
