package org.mule.weave.v2.runtime.core.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.model.structure.BufferedCharSequence
import org.mule.weave.v2.parser.location.Location

class ReadExecutionException(val location: Location, val content: CharSequence, mimeType: String, cause: String) extends ExecutionException {
  override def message = {
    s"Exception while reading '${content}' as '${mimeType}' cause by:\n${cause}"
  }
}

object ReadExecutionException {
  def apply(location: Location, content: CharSequence, mimeType: String, cause: String): ReadExecutionException = {
    val largeContent = content match {
      case s: String =>
        s.length > 25
      case bcs: BufferedCharSequence =>
        bcs.lengthCompare(25) > 0
      case _ =>
        content.length > 25
    }
    val contentText = if (largeContent) {
      content.subSequence(0, 23) + "..."
    } else {
      content
    }
    new ReadExecutionException(location, contentText, mimeType, cause)
  }
}