package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.ValueProvider
import org.mule.weave.v2.runtime.core.exception.SleepInterruptedException

object WaitFunctionValue extends BinaryFunctionValue {
  override val L = AnyType
  override val R = NumberType

  override def doExecute(valueValue: L.V, timeValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val timeout = timeValue.evaluate.toLong
    if (timeout > 0) {
      try {
        ctx.serviceManager.cpuLimitService.check(this.location(), timeout)
        Thread.sleep(timeout)
      } catch {
        case _: InterruptedException => throw new SleepInterruptedException(timeValue.location())
      }
    }
    valueValue
  }
  override val rightDefaultValue: Option[ValueProvider] = Some(ValueProvider(NumberValue(1000)))
}
