package org.mule.weave.v2.runtime.core.operator.relational

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class GreaterOrEqualThanOperator(override val location: WeaveLocation) extends BaseRelationalOperator {

  protected def doCompare(leftValue: Value[_], rightValue: Value[_])(implicit ctx: EvaluationContext): BooleanValue = {
    BooleanValue(leftValue.compareTo(rightValue) >= 0, this)
  }

}
