package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.EmptyFilterSelectorException
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.StrictSelectionOverNullSelection
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.types.NullType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.functions.collections.ArrayFilterFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectFilterFunctionValue

class ArrayFilterSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = ArrayType

  override val R = FunctionType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): ArrayValue = {
    val filteredValue = ArrayFilterFunctionValue.doExecute(leftValue, rightValue)
    if (filteredValue.evaluate.isEmpty) {
      throw InvalidSelectionException(new EmptyFilterSelectorException(this.location))
    } else {
      filteredValue
    }
  }
}

class ObjectFilterSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = ObjectType

  override val R = FunctionType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): ObjectValue = {
    val filteredValue = ObjectFilterFunctionValue.doExecute(leftValue, rightValue)
    if (filteredValue.evaluate.isEmpty()) {
      throw InvalidSelectionException(new EmptyFilterSelectorException(this.location))
    } else {
      filteredValue
    }
  }
}

class NullFilterSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = NullType

  override val R = FunctionType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): ObjectValue = {
    throw InvalidSelectionException(new StrictSelectionOverNullSelection(this))
  }
}

object FilterSelectorOperator {
  def value(location: WeaveLocation): Array[BinaryFunctionValue] = Array(new ArrayFilterSelectorOperator(location), new ObjectFilterSelectorOperator(location), new NullFilterSelectorOperator(location))
}