/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.telemetry.service;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.mule.weave.v2.core.telemetry.service.api.TelemetryService;
import org.mule.weave.v2.core.util.IntervalExecutor;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.service.RuntimeSettings$;
import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.telemetry.service.DisruptorTelemetryEvent;
import org.mule.weave.v2.telemetry.service.DisruptorTelemetryEventFactory;
import org.mule.weave.v2.telemetry.service.FileTelemetryEventWriter;
import org.mule.weave.v2.telemetry.service.TelemetryEventHandler;
import org.mule.weave.v2.telemetry.service.TelemetryEventWriter;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\f\u0019\u0001\u0015BQA\u000e\u0001\u0005\u0002]B\u0011B\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001e\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003=\u0011%\u0011\u0006\u00011AA\u0002\u0013%1\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I1\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0016\u0005\n9\u0002\u0001\r\u00111A\u0005\nuC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00022\t\u0013\u0011\u0004\u0001\u0019!A!B\u0013q\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B4\t\u000f9\u0004\u0001\u0019!C\u0005_\"91\u000f\u0001a\u0001\n\u0013!\bB\u0002<\u0001A\u0003&\u0001\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0003~\u0001\u0011\u0005a\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003+\u0001A\u0011IA\f\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005M\u0004\u0001\"\u0011\u0002r\t9B)\u001a4bk2$H+\u001a7f[\u0016$(/_*feZL7-\u001a\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u001c9\u0005IA/\u001a7f[\u0016$(/\u001f\u0006\u0003;y\t!A\u001e\u001a\u000b\u0005}\u0001\u0013!B<fCZ,'BA\u0011#\u0003\u0011iW\u000f\\3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0004CBL'BA\r2\u0015\tY\"G\u0003\u000249\u0005!1m\u001c:f\u0013\t)dF\u0001\tUK2,W.\u001a;ssN+'O^5dK\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011\u0001G\u0001\nI&\u001c(/\u001e9u_J,\u0012\u0001\u0010\t\u0004{\u0015;U\"\u0001 \u000b\u0005}\u0002\u0015a\u00013tY*\u0011!(\u0011\u0006\u0003\u0005\u000e\u000bA\u0001\\7bq*\tA)A\u0002d_6L!A\u0012 \u0003\u0013\u0011K7O];qi>\u0014\bCA\u001dI\u0013\tI\u0005DA\fESN\u0014X\u000f\u001d;peR+G.Z7fiJLXI^3oi\u0006iA-[:skB$xN]0%KF$\"\u0001T(\u0011\u0005\u001dj\u0015B\u0001()\u0005\u0011)f.\u001b;\t\u000fA\u001b\u0011\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\u0002\u0015\u0011L7O];qi>\u0014\b%\u0001\u0007nsJKgn\u001a\"vM\u001a,'/F\u0001U!\r)fkR\u0007\u0002\u0001&\u0011q\u000b\u0011\u0002\u000b%&twMQ;gM\u0016\u0014\u0018\u0001E7z%&twMQ;gM\u0016\u0014x\fJ3r)\ta%\fC\u0004Q\r\u0005\u0005\t\u0019\u0001+\u0002\u001b5L(+\u001b8h\u0005V4g-\u001a:!\u0003-)g/\u001a8u/JLG/\u001a:\u0016\u0003y\u0003\"!O0\n\u0005\u0001D\"\u0001\u0006+fY\u0016lW\r\u001e:z\u000bZ,g\u000e^,sSR,'/A\bfm\u0016tGo\u0016:ji\u0016\u0014x\fJ3r)\ta5\rC\u0004Q\u0013\u0005\u0005\t\u0019\u00010\u0002\u0019\u00154XM\u001c;Xe&$XM\u001d\u0011\u0002!\t,hMZ3s\rVdG\u000eT8hO\u0016\u0014X#A4\u0011\u0005!\\W\"A5\u000b\u0005)\u0014\u0014\u0001B;uS2L!\u0001\\5\u0003!%sG/\u001a:wC2,\u00050Z2vi>\u0014\u0018!\u00052vM\u001a,'OR;mY2{wmZ3sA\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\u0005\u0001\bCA\u0014r\u0013\t\u0011\bFA\u0004C_>dW-\u00198\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$\"\u0001T;\t\u000fAs\u0011\u0011!a\u0001a\u0006a\u0011N\\5uS\u0006d\u0017N_3eA!\u0012q\u0002\u001f\t\u0003OeL!A\u001f\u0015\u0003\u0011Y|G.\u0019;jY\u0016\f!B]5oO\n+hMZ3s)\u0005!\u0016!D5t\u0013:LG/[1mSj,G\rF\u0001q\u00039Ig.\u001b;JMJ+\u0017/^5sK\u0012$\"!a\u0001\u0015\u00071\u000b)\u0001C\u0004\u0002\bI\u0001\u001d!!\u0003\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001H\u0001\u0006[>$W\r\\\u0005\u0005\u0003'\tiAA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fA\u0002];cY&\u001c\b.\u0012<f]R$\"\"!\u0007\u0002\u001e\u0005]\u0012\u0011JA')\ra\u00151\u0004\u0005\b\u0003\u000f\u0019\u00029AA\u0005\u0011\u001d\tyb\u0005a\u0001\u0003C\tAa[5oIB!\u00111EA\u0019\u001d\u0011\t)#!\f\u0011\u0007\u0005\u001d\u0002&\u0004\u0002\u0002*)\u0019\u00111\u0006\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0003K\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=\u0002\u0006C\u0004\u0002:M\u0001\r!a\u000f\u0002\u00111|7-\u0019;j_:\u0004B!!\u0010\u0002F5\u0011\u0011q\b\u0006\u0005\u0003s\t\tEC\u0002\u0002Dq\ta\u0001]1sg\u0016\u0014\u0018\u0002BA$\u0003\u007f\u0011\u0001\u0002T8dCRLwN\u001c\u0005\b\u0003\u0017\u001a\u0002\u0019AA\u0011\u0003\tIG\rC\u0005\u0002PM\u0001\n\u00111\u0001\u0002R\u0005!A-\u0019;b!\u00159\u00131KA\u0011\u0013\r\t)\u0006\u000b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0017aV\u0014G.[:i\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\f\u0016\u0005\u0003#\nif\u000b\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!C;oG\",7m[3e\u0015\r\tI\u0007K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00151G.^:i)\u0005a\u0015!B2m_N,\u0007")
public class DefaultTelemetryService
implements TelemetryService {
    private Disruptor<DisruptorTelemetryEvent> disruptor;
    private RingBuffer<DisruptorTelemetryEvent> myRingBuffer;
    private TelemetryEventWriter eventWriter;
    private final IntervalExecutor bufferFullLogger = new IntervalExecutor(15L, TimeUnit.MINUTES);
    private volatile boolean initialized = false;

    private Disruptor<DisruptorTelemetryEvent> disruptor() {
        return this.disruptor;
    }

    private void disruptor_$eq(Disruptor<DisruptorTelemetryEvent> x$1) {
        this.disruptor = x$1;
    }

    private RingBuffer<DisruptorTelemetryEvent> myRingBuffer() {
        return this.myRingBuffer;
    }

    private void myRingBuffer_$eq(RingBuffer<DisruptorTelemetryEvent> x$1) {
        this.myRingBuffer = x$1;
    }

    private TelemetryEventWriter eventWriter() {
        return this.eventWriter;
    }

    private void eventWriter_$eq(TelemetryEventWriter x$1) {
        this.eventWriter = x$1;
    }

    private IntervalExecutor bufferFullLogger() {
        return this.bufferFullLogger;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public RingBuffer<DisruptorTelemetryEvent> ringBuffer() {
        return this.myRingBuffer();
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    public void initIfRequired(EvaluationContext ctx) {
        if (!this.initialized()) {
            DefaultTelemetryService defaultTelemetryService = this;
            synchronized (defaultTelemetryService) {
                if (!this.initialized()) {
                    ServiceManager serviceManager = ctx.serviceManager();
                    ThreadFactory threadFactory = Executors.defaultThreadFactory();
                    DisruptorTelemetryEventFactory factory = new DisruptorTelemetryEventFactory();
                    SettingsService settings = ctx.serviceManager().settingsService();
                    int bufferSize = settings.telemetry().bufferSize();
                    this.disruptor_$eq((Disruptor<DisruptorTelemetryEvent>)new Disruptor((EventFactory)factory, bufferSize, threadFactory));
                    this.eventWriter_$eq(new FileTelemetryEventWriter(serviceManager.workingDirectoryService().telemetryDirectory()));
                    this.disruptor().handleEventsWith(new EventHandler[]{new TelemetryEventHandler(this.eventWriter())});
                    this.disruptor().start();
                    this.myRingBuffer_$eq((RingBuffer<DisruptorTelemetryEvent>)this.disruptor().getRingBuffer());
                    this.initialized_$eq(true);
                }
            }
        }
    }

    public void publishEvent(String kind, Location location, String id, String[] data, EvaluationContext ctx) {
        block2: {
            LoggingService loggingService;
            String locationString;
            long timeStamp;
            String threadId;
            block3: {
                String string;
                if (!ctx.serviceManager().settingsService().telemetry().enabled()) break block2;
                threadId = Thread.currentThread().getName();
                timeStamp = System.nanoTime();
                this.initIfRequired(ctx);
                Location location2 = location;
                if (location2 instanceof WeaveLocation) {
                    WeaveLocation weaveLocation = (WeaveLocation)location2;
                    string = weaveLocation.resourceWithLocation();
                } else {
                    string = "Unknown";
                }
                locationString = string;
                if (!ctx.serviceManager().settingsService().telemetry().sync()) break block3;
                this.eventWriter().write(kind, locationString, threadId, id, timeStamp, data);
                break block2;
            }
            boolean tryPublishEvent = this.myRingBuffer().tryPublishEvent((profilerEvent, sequence) -> {
                profilerEvent.kind_$eq(kind);
                profilerEvent.location_$eq(locationString);
                profilerEvent.threadId_$eq(threadId);
                profilerEvent.id_$eq(id);
                profilerEvent.timeStamp_$eq(timeStamp);
                profilerEvent.data_$eq(data);
            });
            if (tryPublishEvent || !(loggingService = ctx.serviceManager().loggingService()).isInfoEnabled()) break block2;
            this.bufferFullLogger().trigger((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> loggingService.logInfo(new StringBuilder(85).append("Ignoring event as the ring bugger is full. Consider increasing the buffer size with ").append(RuntimeSettings$.MODULE$.prop("telemetry.bufferSize")).append(" ").toString()));
        }
    }

    public String[] publishEvent$default$4() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public void flush() {
        block0: {
            if (this.eventWriter() == null) break block0;
            this.disruptor().shutdown();
            this.eventWriter().flush();
        }
    }

    public void close() {
        block0: {
            if (this.eventWriter() == null) break block0;
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.disruptor().shutdown(10L, TimeUnit.SECONDS));
            this.eventWriter().close();
        }
    }
}

