import fail as raiseError from dw::Runtime


/**
 * Raises an execution error if the arguments arent exactly the same.
 */
fun mustEqual(a, b): Boolean =
  if(a == b)
    true
  else
    using(err = raiseError(write(a) as String ++ ' must equal ' ++ write(b) as String))
      false


/**
 * Raises an execution error when the first argument (String) doesn't match the second argument (Regex)
 */
fun mustMatch(a: String, expression: Regex): Boolean =
  if(a matches expression)
    true
  else
    using(err = raiseError(write(a) as String ++ ' must match expression ' ++ write(expression) as String))
      false


/**
 * Raises an execution error when the first argument is false.
 * The second argument is the error message.
 */
fun assert(value: Boolean, message: String = 'Assertion failed'): Boolean =
  if(value == true)
    true
  else
    using(err = raiseError(message))
      false