%dw 2.0

/**
*
* Returns a Period consisting of the number of years, months,
* and days between two dates.
* The start date is included, but the end date is not.
* The period is calculated by removing complete months, then calculating
* the remaining number of days, adjusting to ensure that both have the same sign.
* The number of months is then split into years and months based on a 12 month year.
* A month is considered if the end day-of-month is greater than or equal to the start day-of-month.
* For example, from `2010-01-15` to `2011-03-18` is one year, two months and three days.
* The result of this method can be a negative period if the end is before the start.
*
*  _Introduced in DataWeave 2.3.1. Supported by Mule 4.3.1 and later._
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | startDateInclusive | the start date, inclusive.
* | endDateExclusive | the end date, exclusive.
* |===
*
* === Example
*
* This example shows how the `between` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* import * from dw::core::Periods
* output application/json
* ---
* {
*   a: between(|2010-12-12|,|2010-12-10|),
*   b: between(|2010-12-10|,|2011-12-11|)
* }
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "a": "P2D",
*    "b": "P-1Y-1D"
*  }
* ----
**/
fun between(startDateInclusive: Date, endDateExclusive: Date): Period = native("system::BetweenLocalDateOperator")