%dw 2.0

import ls, nameOf, contentOf, mimeTypeOf, baseNameOf, path, fileTypeOf from dw::test::internal::File
import runUrl from dw::test::internal::Runner
import * from dw::test::Tests
import * from dw::test::Asserts

fun createTestSuite(directory: String): Array<() -> TestResult> = do {
    var mappings = ls(directory)
    ---
    if(isEmpty(mappings))
        []
    else
        flatten(mappings map ((mappingDir) ->
            createTestCases(mappingDir)
        ))
}

fun createTestCases(mappingDir: String): Array<() -> TestResult> = do {
    var testScenario = ls(mappingDir)
    var mappingUrl = "classpath://" ++ (nameOf(mappingDir) replace "-" with "/") ++ ".dwl"
    ---
    testScenario flatMap (testCase) -> do {
      var context = buildContext(path(testCase, "inputs"))
      var outs = ls(testCase, "out.*") map ((expectedPath) -> read(contentOf(expectedPath), mimeTypeOf(expectedPath) default "application/dw"))
      ---
      outs map (expected) -> createTestCase(nameOf(mappingDir) ++ " - " ++ nameOf(testCase), mappingUrl, context, expected)
    }
}

fun buildContext(dir: String) = do {
    var inputs = ls(dir) map (element) -> do {
        {
           (baseNameOf(element)):
               fileTypeOf(element) match {
                    case "FileType" -> read(contentOf(element), mimeTypeOf(element) default "application/dw")
                    case "DirType" -> buildContext(element)
               }
        }
    }
    ---
    {
        (inputs)
    }
}


fun createTestCase(scenario: String, mapping: String, context: Object, expected: Any): () -> TestResult = do {
    () -> scenario in do {
        runUrl(mapping, context) must equalTo(expected)
    }
}
---
describedBy("IntegrationTest", createTestSuite(dw::Runtime::prop("dwitDir") default "dwit"))
