/**
* This runner executes all the DataWeave Integration Test under a given folder
*/
%dw 2.0

import ls, nameOf, contentOf, mimeTypeOf, baseNameOf, path, kindOf from dw::io::file::FileSystem
import createTestSuite from dw::test::internal::DWITUtils
import * from dw::test::Tests
---
describedBy("MappingIntegrationTest",
        createTestSuite(
            dw::Runtime::prop("dwitDir") default "dwit",
       (mappingDir: String, testCase: String) -> //
                        do {
                          var url =  (nameOf(mappingDir) replace "-" with "/") ++ ".dwl"
                          ---
                         {
                          content: readUrl("classpath://" ++ url , "text/plain") as String,
                          url:  url
                        }
                      }
                  )
)

