%dw 2.0
import * from dw::test::Tests
import * from dw::core::Arrays
import * from dw::test::internal::reporter::Reports

input testResult: TestsResult application/json

output application/html with xml
---
html: {
    head: {
        meta @(charset: "utf-8") : null,
        meta @(name: "viewport", content:"width=device-width, initial-scale=1, maximum-scale=1") : null,
        title: "Test Report",
        link @(rel: "stylesheet", href: "https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0-beta/css/materialize.min.css", media: "screen,projection"): null,
        link @(rel: "stylesheet", href: "https://fonts.googleapis.com/icon?family=Material+Icons"): null
    },
    body: {
        header: {
             div @("class":"nav-wrapper"): {
                nav @(class: "blue darken-3"): {
                    a @(class: "brand-logo", href: "#",id: "logo-container"):{
                        img @(class: "logo-img",src: ""): null
                    },
                    ul @(class: "center flow-text"): "TEST RESULTS"
                }
            }
        },
        div @(class: "container"): {
             div @(style: "margin-bottom: 50px;"): {
                 table @(class: "striped responsive-table", id: "example") :{
                    thead: {
                        tr: {
                            th @(class: "center"): "Test Suite",
                            th @(class: "center"): "Passed",
                            th @(class: "center"): "Failed",
                            th @(class: "center"): "Ignored",
                            th @(class: "center"):  "Total",
                        }
                    },
                    tbody: {
                         (
                            testResult map ((testSuite) -> {
                                 tr: {
                                     td @(class: "center"): {
                                         a @(href: "#$(testSuite.name)"): testSuite.name
                                     },
                                     td @(class: "center"): totalOk(testSuite.testResult),
                                     td @(class: "center"): totalFail (testSuite.testResult) + totalErrors(testSuite.testResult),
                                     td @(class: "center"): totalSkip(testSuite.testResult),
                                     td @(class: "center"): totalTests(testSuite.testResult),
                                 }
                            })
                         )
                     },
                 },

             },
             (
                testResult map ((testSuite, index) -> {
                    h4 @(id: testSuite.name): testSuite.name ++ " - " ++ testSuite.testResult.name,
                    h6: "Total Tests Failed : $(totalFail (testSuite.testResult) + totalErrors(testSuite.testResult))",
                    h6: "Total Tests Executed : $(totalTests(testSuite.testResult))",
                    div @(style: "margin-bottom: 50px;"): {
                        table @(class: "striped highlight responsive-table"): {
                            thead: {
                                tr: {
                                    th @(class: "center"): "Test Name",
                                    th @(class: "center"): "Result",
                                    th @(class: "center"): "Failure Reason",
                                }
                            },
                            tbody : {
                                (
                                    testSuite.testResult.tests map ((test, index) ->
                                        if(test.status == OK_STATUS or test.status == SKIP_STATUS)
                                            tr @(class: if(test.status == OK_STATUS) "green lighten-5" else "yellow lighten-5"): {
                                                td @(class: "center"): test.name,
                                                td @(class: "center"): test.status,
                                                td: null
                                            }
                                        else
                                            {
                                                 tr @(class: "red lighten-5") : {
                                                     td @(class: "center"): test.name,
                                                     td @(class: "center"): "Failed",
                                                     td: test.errorMessage
                                                }
                                            }
                                    )
                                )
                            }
                        }
                    }
                })
             )
        },
        footer @(class: "page-footer blue darken-3"): null,
        script @( "type": "text/javascript", src: "https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0-beta/js/materialize.min.js"): null
    }

}
