import countBy from dw::core::Arrays

fun totalFailures(testsuite) = do {
    var status = testsuite..status
    ---
    status match {
      case is Null -> 0
      case is Array -> $ countBy $ == "FAIL"
    }
}

fun totalErrors(testsuite) = do {
    var status = testsuite..status
    ---
    status match {
        case is Null -> 0
        case is Array -> $ countBy $ == "ERROR"
    }
}

fun totalTests(testsuite) = do {
    var testsSuites = testsuite..[?($ is Object and not $.tests?)]
    ---
    testsSuites match {
        case is Null -> 0
        case is Array -> sizeOf($)
    }
}

output application/java
---
{
    failures: totalFailures(testResult),
    errors: totalErrors(testResult),
    total: totalTests(testResult)
}