/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.xmlschema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.mule.weave.v2.module.reader.BOMInputStream;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.xmlschema.SchemaCollector$;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q<QAE\n\t\u0002\u00012QAI\n\t\u0002\rBQAK\u0001\u0005\u0002-BQ\u0001L\u0001\u0005\u00025BQ\u0001L\u0001\u0005\u0002I4AAI\n\u0001_!A\u0001'\u0002BC\u0002\u0013\u0005\u0011\u0007\u0003\u0005>\u000b\t\u0005\t\u0015!\u00033\u0011\u0015QS\u0001\"\u0003?\u0011\u001d\u0001UA1A\u0005\u0002\u0005CaAU\u0003!\u0002\u0013\u0011\u0005\"B*\u0006\t\u0003!\u0006\"B*\u0006\t\u0003Q\u0006\"B*\u0006\t\u0003\u0019\u0007\"B*\u0006\t\u0003A\u0007\"B*\u0006\t\u0003Q\u0007\"B7\u0006\t\u0003\t\u0005\"\u00028\u0006\t\u0013y\u0017aD*dQ\u0016l\u0017mQ8mY\u0016\u001cGo\u001c:\u000b\u0005Q)\u0012!\u0003=nYN\u001c\u0007.Z7b\u0015\t1r#\u0001\u0004n_\u0012,H.\u001a\u0006\u00031e\t!A\u001e\u001a\u000b\u0005iY\u0012!B<fCZ,'B\u0001\u000f\u001e\u0003\u0011iW\u000f\\3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0001\"!I\u0001\u000e\u0003M\u0011qbU2iK6\f7i\u001c7mK\u000e$xN]\n\u0003\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!\u0003-9W\r^%ogR\fgnY3\u0016\u00039\u0002\"!I\u0003\u0014\u0005\u0015!\u0013aB2iCJ\u001cX\r^\u000b\u0002eA\u00111G\u000f\b\u0003ia\u0002\"!\u000e\u0014\u000e\u0003YR!aN\u0010\u0002\rq\u0012xn\u001c;?\u0013\tId%\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d'\u0003!\u0019\u0007.\u0019:tKR\u0004CC\u0001\u0018@\u0011\u0015\u0001\u0004\u00021\u00013\u0003\u001d\u00198\r[3nCN,\u0012A\u0011\t\u0005\u0007\"\u0013$*D\u0001E\u0015\t)e)A\u0004nkR\f'\r\\3\u000b\u0005\u001d3\u0013AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u0004\u001b\u0006\u0004\bCA&Q\u001b\u0005a%BA'O\u0003\tIwNC\u0001P\u0003\u0011Q\u0017M^1\n\u0005Ec%aC%oaV$8\u000b\u001e:fC6\f\u0001b]2iK6\f7\u000fI\u0001\nC\u0012$7k\u00195f[\u0006$\"AL+\t\u000bY[\u0001\u0019A,\u0002\rM\u001c\u0007.Z7b!\tY\u0005,\u0003\u0002Z\u0019\n!a)\u001b7f)\tq3\fC\u0003]\u0019\u0001\u0007Q,A\u0005tG\",W.Y+sYB\u0011a,Y\u0007\u0002?*\u0011\u0001MT\u0001\u0004]\u0016$\u0018B\u00012`\u0005\r)&\u000b\u0014\u000b\u0004]\u00114\u0007\"B3\u000e\u0001\u0004\u0011\u0014\u0001\u00028b[\u0016DQaZ\u0007A\u0002I\nQb]2iK6\f7i\u001c8uK:$HC\u0001\u0018j\u0011\u0015af\u00021\u00013)\rq3\u000e\u001c\u0005\u0006K>\u0001\rA\r\u0005\u0006O>\u0001\rAS\u0001\bG>dG.Z2u\u0003Q9(/\u00199J]\n{U*\u00138qkR\u001cFO]3b[R\u0011!\n\u001d\u0005\u0006cF\u0001\rAS\u0001\rgR\u0014X-Y7U_^\u0013\u0018\r\u001d\u000b\u0003]MDQ\u0001\r\u0003A\u0002I\u0002")
public class SchemaCollector {
    private final String charset;
    private final Map<String, InputStream> schemas;

    public static SchemaCollector getInstance(String string) {
        return SchemaCollector$.MODULE$.getInstance(string);
    }

    public static SchemaCollector getInstance() {
        return SchemaCollector$.MODULE$.getInstance();
    }

    public String charset() {
        return this.charset;
    }

    public Map<String, InputStream> schemas() {
        return this.schemas;
    }

    public SchemaCollector addSchema(File schema) {
        try {
            this.schemas().put((Object)schema.toURI().toString(), (Object)this.wrapInBOMInputStream(new FileInputStream(schema)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(new StringBuilder(33).append("Error while adding schema file [").append(schema.getName()).append("]").toString(), e);
        }
        return this;
    }

    public SchemaCollector addSchema(URL schemaUrl) {
        try {
            this.schemas().put((Object)schemaUrl.toString(), (Object)this.wrapInBOMInputStream(schemaUrl.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(new StringBuilder(35).append("Error while adding schema of URL [").append(schemaUrl).append("]").toString(), e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, String schemaContent) {
        this.schemas().put((Object)name, (Object)this.wrapInBOMInputStream(new ByteArrayInputStream(schemaContent.getBytes(Charset.forName(this.charset())))));
        return this;
    }

    public SchemaCollector addSchema(String schemaUrl) {
        try {
            this.addSchema(new URL(schemaUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(new StringBuilder(31).append("The specified URL [").append(schemaUrl).append("] is invalid").toString(), e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, InputStream schemaContent) {
        this.schemas().put((Object)name, (Object)this.wrapInBOMInputStream(schemaContent));
        return this;
    }

    public Map<String, InputStream> collect() {
        return this.schemas();
    }

    private InputStream wrapInBOMInputStream(InputStream streamToWrap) {
        return (InputStream)CharsetHelper$.MODULE$.getBom(Charset.defaultCharset()).map((Function1 & Serializable & scala.Serializable)bomMarker -> new BOMInputStream(streamToWrap, bomMarker)).getOrElse((Function0 & Serializable & scala.Serializable)() -> streamToWrap);
    }

    public SchemaCollector(String charset) {
        this.charset = charset;
        this.schemas = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

