package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants
import org.mule.weave.v2.parser.ast.types.{ TypeReferenceNode, WeaveTypeNode }
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import javax.xml.namespace.QName

class BinaryHandler extends XmlHandler {

  val BINARY_TYPES: List[QName] = List(XmlConstants.XSD_HEXBIN, XmlConstants.XSD_BASE64)

  override def handles(schema: QName): Boolean = BINARY_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    TypeReferenceNode(NameIdentifier("Binary"))
  }
}
