package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants.{ XSD_BOOLEAN, XSD_DATE }
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.structure.schema.{ SchemaNode, SchemaPropertyNode }
import org.mule.weave.v2.parser.ast.types.{ TypeReferenceNode, WeaveTypeNode }
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import javax.xml.namespace.QName

class DateHandler extends XmlHandler {

  val DATE_TYPES: List[QName] = List(XSD_DATE)

  override def handles(schema: QName): Boolean = DATE_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    TypeReferenceNode(NameIdentifier("LocalDateTime"), None, None)
  }
}
