package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.SchemaHelper
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.types.LiteralTypeNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import javax.xml.namespace.QName

class StringHandler extends XmlHandler {

  val STRING_TYPES: List[QName] = List(XmlConstants.XSD_STRING, XmlConstants.XSD_ANY, XmlConstants.XSD_NORMALIZEDSTRING)

  override def handles(schema: QName): Boolean = STRING_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    val enumeration = xsTypeDefinition.getLexicalEnumeration
    if (!enumeration.isEmpty) {
      val values = enumeration.toArray(new Array[String](enumeration.size))
      if (values.length == 1) {
        LiteralTypeNode(StringNode(values(0)))
      } else {
        SchemaHelper.buildUnionTypeNode(values, (stringValue: String) => LiteralTypeNode(StringNode(stringValue).withQuotation('\"')))
      }
    } else {
      TypeReferenceNode(NameIdentifier("String"))
    }
  }
}
